const express = require("express");
const router = express.Router();
const auth = require("../middleware/auth");
const Leave = require("../models/Leave");

// Apply Leave
router.post("/apply", auth(["employee"]), async (req, res) => {
    try {
        const leave = await Leave.create({
            ...req.body,
            user: req.user.id,
        });
        res.status(201).json(leave);
    } catch (error) {
        res.status(500).json({ message: "Server Error", error: error.message });
    }
});

// Employee Show Own Leave
router.get("/me", auth(["employee"]), async (req, res) => {
    try {
        const leave = await Leave.find({ user: req.user.id });
        res.status(200).json(leave);
    }
    catch (error) {
        res.status(500).json({ message: "Server Error", error: error.message });
    }
});

// // Admin see all leave
router.get("/all", auth(["admin"]), async (req, res) => {
    try {
        const leave = await Leave.find().populate("user", "name email");
        res.status(200).json(leave);
    }
    catch (error) {
        res.status(500).json({ message: "Server Error", error: error.message });
    }
});

// // Admin approve/reject
router.put("/:id", auth(["admin"]), async (req, res) => {
    try {
        const leave = await Leave.findByIdAndUpdate(req.params.id, req.body, { new: true });
        res.status(200).json(leave);
    }
    catch (error) {
        res.status(500).json({ message: "Server Error", error: error.message });
    }
});

module.exports = router;